<?php
require 'includes/auth_check.php';
require 'includes/header.php';

// Handle form submissions (Add/Edit/Delete)
$message = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['add_task'])) {
        // Add new task
        $title = $conn->real_escape_string($_POST['title']);
        $link = $conn->real_escape_string($_POST['link']);
        $reward = (float)$_POST['reward'];
        $conn->query("INSERT INTO tasks (title, link, reward) VALUES ('$title', '$link', '$reward')");
        $message = "New task added successfully!";
    } elseif (isset($_POST['delete_task'])) {
        // Delete task
        $task_id = (int)$_POST['task_id'];
        $conn->query("DELETE FROM tasks WHERE id = $task_id");
        // Also remove completed records for this task
        $conn->query("DELETE FROM user_completed_tasks WHERE task_id = $task_id");
        $message = "Task deleted successfully!";
    }
}

// Fetch all tasks
$tasks_result = $conn->query("SELECT * FROM tasks ORDER BY id DESC");
?>
<header>
    <h1>Manage Bonus Tasks</h1>
</header>

<?php if(!empty($message)): ?><div class="alert" style="background-color: var(--success-color);"><?= $message ?></div><?php endif; ?>

<div class="card">
    <h3>Add New Task</h3>
    <form method="post">
        <div class="form-group">
            <label>Task Title</label>
            <input type="text" name="title" placeholder="e.g., Join our Telegram Channel" required>
        </div>
        <div class="form-group">
            <label>Link</label>
            <input type="text" name="link" placeholder="https://t.me/yourchannel" required>
        </div>
        <div class="form-group">
            <label>Reward</label>
            <input type="number" name="reward" step="0.01" placeholder="e.g., 2.00" required>
        </div>
        <button type="submit" name="add_task" class="btn btn-primary">Add Task</button>
    </form>
</div>

<div class="card">
    <h3>Existing Tasks</h3>
    <table class="data-table">
        <thead>
            <tr>
                <th>Title</th>
                <th>Link</th>
                <th>Reward (BD)</th>
                <th>Action</th>
            </tr>
        </thead>
        <tbody>
            <?php if ($tasks_result->num_rows > 0): ?>
                <?php while($task = $tasks_result->fetch_assoc()): ?>
                <tr>
                    <td><?= htmlspecialchars($task['title']) ?></td>
                    <td><?= htmlspecialchars($task['link']) ?></td>
                    <td><?= number_format($task['reward'], 2) ?></td>
                    <td>
                        <form method="post" onsubmit="return confirm('Are you sure you want to delete this task? All records of its completion will also be removed.');">
                            <input type="hidden" name="task_id" value="<?= $task['id'] ?>">
                            <button type="submit" name="delete_task" class="btn btn-danger">Delete</button>
                        </form>
                    </td>
                </tr>
                <?php endwhile; ?>
            <?php else: ?>
                <tr>
                    <td colspan="4">No tasks created yet.</td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>
</div>

<?php require 'includes/footer.php'; ?>