<?php
require 'includes/auth_check.php';
require 'includes/header.php';

// Search functionality
$search = isset($_GET['search']) ? $conn->real_escape_string($_GET['search']) : '';
$where_clause = '';
if (!empty($search)) {
    $where_clause = "WHERE first_name LIKE '%$search%' OR username LIKE '%$search%' OR telegram_id LIKE '%$search%'";
}

// Pagination
$limit = 20; // Number of users per page
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$offset = ($page - 1) * $limit;

// Get total number of users for pagination
$total_results = $conn->query("SELECT COUNT(*) FROM users $where_clause")->fetch_row()[0];
$total_pages = ceil($total_results / $limit);

// Fetch users for the current page
$users_result = $conn->query("SELECT * FROM users $where_clause ORDER BY id DESC LIMIT $limit OFFSET $offset");
?>

<header>
    <h1>Manage Users</h1>
</header>

<div class="card">
    <form method="get" action="users.php" style="margin-bottom: 20px;">
        <input type="text" name="search" placeholder="Search by Name, Username, or TG ID" value="<?= htmlspecialchars($search) ?>" style="width: 300px; display: inline-block;">
        <button type="submit" class="btn btn-primary">Search</button>
    </form>

    <table class="data-table">
        <thead>
            <tr>
                <th>ID</th>
                <th>TG ID</th>
                <th>First Name</th>
                <th>Username</th>
                <th>Balance (BD)</th>
                <th>Total Earned (BD)</th>
                <th>Joined On</th>
            </tr>
        </thead>
        <tbody>
            <?php if ($users_result->num_rows > 0): ?>
                <?php while($user = $users_result->fetch_assoc()): ?>
                <tr>
                    <td><?= $user['id'] ?></td>
                    <td><?= $user['telegram_id'] ?></td>
                    <td><?= htmlspecialchars($user['first_name']) ?></td>
                    <td><?= $user['username'] ? '@' . htmlspecialchars($user['username']) : 'N/A' ?></td>
                    <td><?= number_format($user['balance'], 2) ?></td>
                    <td><?= number_format($user['total_earnings'], 2) ?></td>
                    <td><?= date('d M, Y', strtotime($user['created_at'])) ?></td>
                </tr>
                <?php endwhile; ?>
            <?php else: ?>
                <tr>
                    <td colspan="7">No users found.</td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>

    <!-- Pagination Links -->
    <div style="margin-top: 20px;">
        <?php for ($i = 1; $i <= $total_pages; $i++): ?>
            <a href="users.php?page=<?= $i ?>&search=<?= urlencode($search) ?>" style="padding: 5px 10px; <?= $i == $page ? 'font-weight:bold;' : '' ?>"><?= $i ?></a>
        <?php endfor; ?>
    </div>
</div>

<?php require 'includes/footer.php'; ?>