<?php
require 'includes/auth_check.php';
require 'includes/header.php';

// Handle status updates
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['request_id'])) {
    $request_id = (int)$_POST['request_id'];
    $action = $_POST['action']; // 'approve' or 'reject'

    $conn->begin_transaction();
    try {
        // Get withdrawal details
        $stmt_get = $conn->prepare("SELECT * FROM withdrawals WHERE id = ? AND status = 'pending'");
        $stmt_get->bind_param("i", $request_id);
        $stmt_get->execute();
        $result = $stmt_get->get_result();
        
        if ($result->num_rows === 1) {
            $withdrawal = $result->fetch_assoc();
            
            if ($action === 'approve') {
                $new_status = 'completed';
            } elseif ($action === 'reject') {
                $new_status = 'rejected';
                // Refund the amount to the user's balance
                $conn->query("UPDATE users SET balance = balance + {$withdrawal['amount']} WHERE telegram_id = {$withdrawal['user_telegram_id']}");
            }
            
            // Update withdrawal status
            $stmt_update = $conn->prepare("UPDATE withdrawals SET status = ?, processed_at = NOW() WHERE id = ?");
            $stmt_update->bind_param("si", $new_status, $request_id);
            $stmt_update->execute();
            
            $conn->commit();
            $message = "Request #$request_id has been " . ($action === 'approve' ? 'approved' : 'rejected') . ".";
        } else {
            throw new Exception("Request not found or already processed.");
        }
    } catch (Exception $e) {
        $conn->rollback();
        $error = "Error: " . $e->getMessage();
    }
}

// Fetch withdrawal requests
$filter = isset($_GET['filter']) ? $_GET['filter'] : 'pending';
$allowed_filters = ['pending', 'completed', 'rejected'];
if (!in_array($filter, $allowed_filters)) {
    $filter = 'pending';
}

$withdrawals_result = $conn->query("
    SELECT w.*, u.first_name, u.username 
    FROM withdrawals w
    JOIN users u ON w.user_telegram_id = u.telegram_id
    WHERE w.status = '$filter' 
    ORDER BY w.requested_at DESC
");
?>

<header>
    <h1>Manage Withdrawals</h1>
</header>

<div class="card">
    <div style="margin-bottom: 20px;">
        Filter by status:
        <?php foreach ($allowed_filters as $f): ?>
            <a href="?filter=<?= $f ?>" style="padding: 5px 10px; <?= $f == $filter ? 'font-weight:bold; background-color:#ddd;' : '' ?>"><?= ucfirst($f) ?></a>
        <?php endforeach; ?>
    </div>

    <?php if(isset($message)): ?><div class="alert" style="background-color: var(--success-color);"><?= $message ?></div><?php endif; ?>
    <?php if(isset($error)): ?><div class="alert alert-danger"><?= $error ?></div><?php endif; ?>

    <table class="data-table">
        <thead>
            <tr>
                <th>User</th>
                <th>Method</th>
                <th>Account Number</th>
                <th>Amount (BD)</th>
                <th>Requested At</th>
                <?php if ($filter === 'pending'): ?>
                    <th>Actions</th>
                <?php else: ?>
                    <th>Processed At</th>
                <?php endif; ?>
            </tr>
        </thead>
        <tbody>
            <?php if ($withdrawals_result->num_rows > 0): ?>
                <?php while($row = $withdrawals_result->fetch_assoc()): ?>
                <tr>
                    <td><?= htmlspecialchars($row['first_name']) ?> (@<?= htmlspecialchars($row['username']) ?>)</td>
                    <td><?= htmlspecialchars($row['method']) ?></td>
                    <td><?= htmlspecialchars($row['account_number']) ?></td>
                    <td><?= number_format($row['amount'], 2) ?></td>
                    <td><?= date('d M Y, h:i A', strtotime($row['requested_at'])) ?></td>
                    <?php if ($filter === 'pending'): ?>
                        <td>
                            <form method="post" style="display:inline;">
                                <input type="hidden" name="request_id" value="<?= $row['id'] ?>">
                                <button type="submit" name="action" value="approve" class="btn btn-success" onclick="return confirm('Are you sure you want to approve this request?')">Approve</button>
                            </form>
                            <form method="post" style="display:inline;">
                                <input type="hidden" name="request_id" value="<?= $row['id'] ?>">
                                <button type="submit" name="action" value="reject" class="btn btn-danger" onclick="return confirm('Are you sure you want to reject this request? The amount will be refunded to the user.')">Reject</button>
                            </form>
                        </td>
                    <?php else: ?>
                        <td><?= date('d M Y, h:i A', strtotime($row['processed_at'])) ?></td>
                    <?php endif; ?>
                </tr>
                <?php endwhile; ?>
            <?php else: ?>
                <tr>
                    <td colspan="6">No <?= $filter ?> withdrawal requests found.</td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>
</div>

<?php require 'includes/footer.php'; ?>