<?php
// --- ERROR REPORTING (VERY IMPORTANT FOR DEBUGGING) ---
// This will help us see if there are any PHP errors on the server.
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// --- TIMEZONE SETUP ---
// Set the timezone to your local time to ensure all dates are correct.
date_default_timezone_set('Asia/Dhaka');

// --- DATABASE CONNECTION CREDENTIALS ---
// IMPORTANT: Fill these with your actual database details from your hosting.
$servername = "localhost";
$username = "codeworks_mini100"; // <-- আপনার cPanel ডাটাবেসের ইউজারনেম দিন
$password = "codeworks_mini100"; // <-- আপনার ডাটাবেসের পাসওয়ার্ড দিন
$dbname = "codeworks_mini100";       // <-- আপনার ডাটাবেসের নাম দিন

// --- CREATE AND CHECK CONNECTION ---
$conn = new mysqli($servername, $username, $password, $dbname);

// Check for connection errors
if ($conn->connect_error) {
    // If connection fails, stop everything and show an error.
    // This is often the main reason for data not loading.
    die("Database Connection Failed: " . $conn->connect_error);
}

// --- SET CHARACTER SET ---
// This ensures that Bangla characters and emojis are handled correctly.
$conn->set_charset("utf8mb4");

// --- HELPER FUNCTION (Optional but useful) ---
// This function can be used in other files to easily get a setting.
function get_setting($conn, $key) {
    $stmt = $conn->prepare("SELECT setting_value FROM settings WHERE setting_key = ?");
    $stmt->bind_param("s", $key);
    $stmt->execute();
    $result = $stmt->get_result();
    if($row = $result->fetch_assoc()) {
        return $row['setting_value'];
    }
    return null;
}
?>